﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Data.SqlClient;
using System.Data;
using System.Reflection;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public static class SQLHelper
    {
        public static void ExecuteQuery(string storedProcedure, List<SqlParameter> param)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.ConnectionString))
            {
                using (SqlCommand command = new SqlCommand(storedProcedure, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.StoredProcedure;
                    command.CommandTimeout = 0;
                    AddParamters(command.Parameters, param);
                    command.ExecuteNonQuery();
                }
            }
        }

        public static void ExecuteOfflineQuery(string storedProcedure, List<SqlParameter> param)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.LocalConnectionString()))
            {
                using (SqlCommand command = new SqlCommand(storedProcedure, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.StoredProcedure;
                    command.CommandTimeout = 0;
                    AddParamters(command.Parameters, param);
                    command.ExecuteNonQuery();
                }
            }
        }

        public static void ExecuteQueryStatement(string Query)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.LocalConnectionString()))
            {
                using (SqlCommand command = new SqlCommand(Query, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.Text;
                    command.CommandTimeout = 0;
                    command.ExecuteNonQuery();
                }
            }
        }

        public static object ExecuteScalar(string storedProcedure, List<SqlParameter> param)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.ConnectionString))
            {
                using (SqlCommand command = new SqlCommand(storedProcedure, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.StoredProcedure;
                    command.CommandTimeout = 0;
                    AddParamters(command.Parameters, param);
                    return command.ExecuteScalar();
                }
            }
        }

        public static DataTable ExecuteDataTable(string storedProcedure, List<SqlParameter> param)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.ConnectionString))
            {
                using (SqlCommand command = new SqlCommand(storedProcedure, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.StoredProcedure;
                    command.CommandTimeout = 0;
                    AddParamters(command.Parameters, param);

                    DataTable table = new DataTable();
                    table.Load(command.ExecuteReader());
                    return table;
                }
            }
        }

        public static DataSet ExecuteDataSet(string storedProcedure, List<SqlParameter> param)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.ConnectionString))
            {
                using (SqlCommand command = new SqlCommand(storedProcedure, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.StoredProcedure;
                    command.CommandTimeout = 0;
                    AddParamters(command.Parameters, param);
                    DataSet myTable = new DataSet();
                    using (SqlDataAdapter adapter = new SqlDataAdapter(command))
                    {
                        adapter.Fill(myTable);
                    }
                    return myTable;
                }
            }
        }

        public static T RetrieveObject<T>(string storedProcedure, List<SqlParameter> param)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.ConnectionString))
            {
                using (SqlCommand command = new SqlCommand(storedProcedure, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.StoredProcedure;
                    command.CommandTimeout = 0;
                    AddParamters(command.Parameters, param);

                    using (SqlDataReader reader = command.ExecuteReader())
                    {
                        if (reader.Read())
                            return LoadData<T>(reader);

                        return default(T);
                    }
                }
            }
        }

        public static List<T> RetrieveList<T>(string storedProcedure, List<SqlParameter> param)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.ConnectionString))
            {
                using (SqlCommand command = new SqlCommand(storedProcedure, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.StoredProcedure;
                    command.CommandTimeout = 0;
                    AddParamters(command.Parameters, param);

                    using (SqlDataReader reader = command.ExecuteReader())
                    {
                        List<T> result = new List<T>();

                        while (reader.Read())
                            result.Add(LoadData<T>(reader));

                        return result;
                    }
                }
            }
        }

        public static List<T> RetrieveOfflineList<T>(string storedProcedure, List<SqlParameter> param)
        {
            using (SqlConnection connection = new SqlConnection(GlobalConfigurations.AppConfiguration.LocalConnectionString()))
            {
                using (SqlCommand command = new SqlCommand(storedProcedure, connection))
                {
                    connection.Open();
                    command.CommandType = CommandType.StoredProcedure;
                    command.CommandTimeout = 0;
                    AddParamters(command.Parameters, param);

                    using (SqlDataReader reader = command.ExecuteReader())
                    {
                        List<T> result = new List<T>();

                        while (reader.Read())
                            result.Add(LoadData<T>(reader));

                        return result;
                    }
                }
            }
        }

        private static void AddParamters(SqlParameterCollection collection, List<SqlParameter> param)
        {
            if (param != null)
            {
                foreach (SqlParameter p in param)
                {
                    if (p.Value == null)
                        p.Value = DBNull.Value;

                    collection.Add(p);
                }
            }
        }

        private static T LoadData<T>(IDataReader reader)
        {
            //convert single column to primitive type
            if (reader.FieldCount == 1)
                return TryParse<T>(reader[0]);

            //for multiple columns call the input type's constructor that takes in IDataReader
            ConstructorInfo c = typeof(T).GetConstructor(new Type[] { typeof(IDataReader) });
            return (T)c.Invoke(new object[] { reader });
        }

        public static T TryParse<T>(object value)
        {
            try { return (T)System.ComponentModel.TypeDescriptor.GetConverter(typeof(T)).ConvertFrom(value.ToString()); }
            catch (Exception) { return default(T); }
        }
    }
}
